/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.resource.loader.impl;

import com.mojang.logging.LogUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_151;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3264;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.qsl.resource.loader.api.ResourcePackActivationType;
import org.quiltmc.qsl.resource.loader.impl.ModResourcePackUtil;
import org.quiltmc.qsl.resource.loader.mixin.IdentifierAccessor;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ModNioResourcePack
extends class_3255 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String name;
    private final class_2561 displayName;
    final ModMetadata modInfo;
    private final ResourcePackActivationType activationType;
    private final Path basePath;
    final class_3264 type;
    @Nullable
    private final AutoCloseable closer;
    private final String separator;
    private final boolean cacheable;
    private final Map<class_3264, Set<String>> namespaces = new EnumMap<class_3264, Set<String>>(class_3264.class);

    static ModNioResourcePack ofMod(ModMetadata modInfo, Path path, class_3264 type, @Nullable String name) {
        return new ModNioResourcePack(name, modInfo, null, ResourcePackActivationType.ALWAYS_ENABLED, path, type, null);
    }

    public ModNioResourcePack(@Nullable String name, ModMetadata modInfo, @Nullable class_2561 displayName, ResourcePackActivationType activationType, Path path, class_3264 type, @Nullable AutoCloseable closer) {
        super(null);
        this.name = name == null ? ModResourcePackUtil.getName(modInfo) : name;
        this.displayName = displayName == null ? new class_2585(name) : displayName;
        this.modInfo = modInfo;
        this.basePath = path.toAbsolutePath().normalize();
        this.type = type;
        this.cacheable = modInfo.getId().equals("minecraft") || !FabricLoader.getInstance().isDevelopmentEnvironment();
        this.closer = closer;
        this.separator = this.basePath.getFileSystem().getSeparator();
        this.activationType = activationType;
    }

    private Path getPath(String filename) {
        Path childPath = this.basePath.resolve(filename.replace("/", this.separator)).toAbsolutePath().normalize();
        if (childPath.startsWith(this.basePath) && Files.exists(childPath, new LinkOption[0])) {
            return childPath;
        }
        return null;
    }

    protected InputStream method_14391(String filename) throws IOException {
        Path path = this.getPath(filename);
        if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        InputStream stream = ModResourcePackUtil.openDefault(this.modInfo, this.type, filename);
        if (stream != null) {
            return stream;
        }
        throw new FileNotFoundException("\"" + filename + "\" in Quilt mod \"" + this.modInfo.getId() + "\"");
    }

    protected boolean method_14393(String filename) {
        if (ModResourcePackUtil.containsDefault(this.modInfo, filename)) {
            return true;
        }
        Path path = this.getPath(filename);
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String path, int depth, Predicate<String> pathFilter) {
        Path searchPath;
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        String nioPath = path.replace("/", this.separator);
        Path namespacePath = this.getPath(type.method_14413() + "/" + namespace);
        if (namespacePath != null && Files.exists(searchPath = namespacePath.resolve(nioPath).toAbsolutePath().normalize(), new LinkOption[0])) {
            try {
                Files.walk(searchPath, depth, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                    String filename = p.getFileName().toString();
                    return !filename.endsWith(".mcmeta") && pathFilter.test(filename);
                }).map(namespacePath::relativize).map(p -> p.toString().replace(this.separator, "/")).forEach(s -> {
                    try {
                        ids.add(new class_2960(namespace, s));
                    }
                    catch (class_151 e) {
                        LOGGER.error(e.getMessage());
                    }
                });
            }
            catch (IOException e) {
                LOGGER.warn("findResources at " + path + " in namespace " + namespace + ", mod " + this.modInfo.getId() + " failed!", (Throwable)e);
            }
        }
        return ids;
    }

    protected void warnInvalidNamespace(String s) {
        LOGGER.warn("Quilt NioResourcePack: ignored invalid namespace: {} in mod ID {}", (Object)s, (Object)this.modInfo.getId());
    }

    public Set<String> method_14406(class_3264 type) {
        Set<String> namespaces;
        if (this.cacheable && (namespaces = this.namespaces.get(type)) != null) {
            return namespaces;
        }
        try {
            Path typePath = this.getPath(type.method_14413());
            if (typePath == null || !Files.isDirectory(typePath, new LinkOption[0])) {
                return Collections.emptySet();
            }
            HashSet<String> namespaces2 = new HashSet<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(typePath, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path path : stream) {
                    String s = path.getFileName().toString();
                    if (IdentifierAccessor.callIsNamespaceValid(s = s.replace(this.separator, ""))) {
                        namespaces2.add(s);
                        continue;
                    }
                    this.warnInvalidNamespace(s);
                }
            }
            if (this.cacheable) {
                this.namespaces.put(type, namespaces2);
            }
            return namespaces2;
        }
        catch (IOException e) {
            LOGGER.warn("getNamespaces in mod " + this.modInfo.getId() + " failed!", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public void close() {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String method_14409() {
        return this.name;
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public ResourcePackActivationType getActivationType() {
        return this.activationType;
    }
}

